/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PlotLine2D.h"

namespace SciFigs {

/*!
  \class PlotLine2D PlotLine2D.h
  \brief A PlotLine2D is a vector of points with appearance properties

  Same as PlotLine excpet that Z(error) coordinate is not stored
*/

PlotLine2D::PlotLine2D(const PlotLine2D& o)
  : AbstractLine(o)
{
  TRACE;
  _curve=o._curve;
}

AbstractLine * PlotLine2D::clone() const
{
  TRACE;
  return new PlotLine2D(*this);
}

bool PlotLine2D::canCopy(const AbstractLine& o) const
{
  TRACE;
  return dynamic_cast<const PlotLine2D *>(&o);
}

void PlotLine2D::operator=(const AbstractLine& o)
{
  TRACE;
  const PlotLine2D * co=dynamic_cast<const PlotLine2D *>(&o);
  ASSERT(co);
  _curve=co->_curve;
  AbstractLine::operator=(o);
}

/*!
  Description still missing
*/
void PlotLine2D::setCurve(const Curve<Point2D>& curve)
{
  TRACE;
  _curve=curve;
}

/*!
  Description still missing
*/
void PlotLine2D::setCurve(  const Curve<Point2D>& curve, const Pen& pen, const Symbol& sym)
{
  TRACE;
  setCurve(curve);
  setPen(pen);
  setSymbol(sym);
  setSelected(false);
}

/*!
  Description still missing
*/
void PlotLine2D::setCurve(VectorList<double> * dataX, VectorList<double> * dataY)
{
  TRACE;
  int n;
  if(dataX) n=dataX->size(); else n=0;
  if(n>0) {
    _curve.resize(n);
    for(int j=0; j<n; j++) {
      Point2D& p=_curve.at(j);
      p.setX(dataX->at(j));
      p.setY(dataY->at(j));
    }
  }
}

} // namespace SciFigs
