/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-26
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "NameLineDelegate.h"

namespace SciFigs {

  /*!
    \class NameLineDelegate NameLineDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  QWidget * NameLineDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                           const QModelIndex & index) const
  {
    TRACE;
    DoubleSpinBox * w=createDoubleSpinBox(parent);
    connect(w, SIGNAL(valueChanged(double)), this, SLOT(commitWidget()));
    switch(index.column()) {
    case 0:
    case 1:
      w->setMinimum(-100);
      w->setMaximum(100);
      w->setSingleStep(0.05);
      break;
    default:
      w->setMinimum(-90);
      w->setMaximum(90);
      w->setSingleStep(10);
      break;
    }
    return w;
  }

} // namespace SciFigs
