/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-07
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NAMELINE_H
#define NAMELINE_H

#include "AbstractNameLine.h"

namespace SciFigs {

class SCIFIGS_EXPORT NameLine : public AbstractNameLine
{
public:
  NameLine() {}
  NameLine(const NameLine& o);

  AbstractLine * clone() const;
  void operator=(const AbstractLine& o);
  bool canCopy(const AbstractLine& o) const;

  const QString& xml_tagName() const {return xmlNameLineTag;}
  static const QString xmlNameLineTag;

  int count() const {return _curve.count();}
  void clear() {_curve.clear();}
  void append() {_curve.append(NamedPoint());}
  void insert(int index) {_curve.insert(index, NamedPoint());}
  void removeLast() {  _curve.remove(_curve.count()-1);}
  bool isSorted() const {return _curve.isSorted();}
  void checkSort() {_curve.checkSort();}
  void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    return _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  Point point(int index, const CurvePointOptions *) const {return _curve.constAt(index);}
  QString name(int index) const {return _curve.constAt(index).name();}
  void setX(int index, double v) {_curve.setX(index, v);}
  void setY(int index, double v, const CurvePointOptions *) {_curve.setY(index, v);}
  void setZ(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setZ(v);}
  void setName(int index, QString n) {_curve.constXAt(index).setName(n);}

  QString toString(int index, const CurvePointOptions *) const {return _curve.constAt(index).toString('g', 20);}

  const Curve<NamedPoint>& curve() const {return _curve;}
  Curve<NamedPoint>& curve() {return _curve;}
protected:
  Curve<NamedPoint> _curve;
};

} // namespace SciFigs

#endif // NAMELINE_H
