/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-05-11
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LIVEGRIDLAYER_H
#define LIVEGRIDLAYER_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"
#include "IrregularGrid2DPlot.h"
#include "GridPlot.h"
#include "AutoAdjustScale.h"

namespace SciFigs {

  class SCIFIGS_EXPORT LiveGridLayer : public GridPlot, public AutoAdjustScale
  {
    Q_OBJECT
  public:
    LiveGridLayer(AxisWindow * parent);
    ~LiveGridLayer();

    const QString& xml_tagName() const {return IrregularGrid2DPlot::xmlIrregularGrid2DPlotTag;}

    void setFunction(FunctionPlot * f);
    FunctionPlot * takeFunction();
    const FunctionPlot * function() const {return _function;}

    void setFunctionValid(bool v) {_functionValid=v;}
    bool isFunctionValid() const {return _functionValid;}

    void setSampling(int s) {_sampling=s;}
    int sampling() const {return _sampling;}

    bool hasProperties() {return true;}
    void addProperties(PropertyProxy * pp);
    void removeProperties(PropertyProxy * pp);
    void properties(PropertyWidget * w) const;
    void setProperty(uint wid, int pid, QVariant val);

    QString coordinateTipInfo(const Point2D&, const Point2D& pReal) const;
    Rect boundingRect() const;
    double value(const Point2D& p) const;
  private slots:
    void showAdjustedPalette(const QGpCoreMath::ColorMap& map);
  signals:
    void paletteAdjusted(const QGpCoreMath::ColorMap& map) const;
  protected:
    void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
    void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;

    class SCIFIGS_EXPORT GridIterator
    {
    public:
      GridIterator(const QSize& s, int sampling,
                   bool xReversed, bool yReversed);

      IrregularGrid2D * create(const GraphContentsOptions& gc) const;

      int _nx, _ny;
      int _iStart, _di;
      int _ixGrid, _dixGrid, _ixEndGrid;
      int _iyGrid, _diyGrid, _iyEndGrid;
    };
    virtual IrregularGrid2D * calculateGrid(const GridIterator& it,
                                            const GraphContentsOptions& gc,
                                            const LayerPainterRequest * lp) const;

    FunctionPlot * _function;
    bool _functionValid;
    int _sampling;
  private:
    void adjustPalette(const IrregularGrid2D& grid, ColorMap& pal) const;

    static uint _tab;
  };

} // namespace SciFigs

#endif // LIVEGRIDLAYER_H
