/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-27
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IRREGULARGRID2DDRAW_H
#define IRREGULARGRID2DDRAW_H

#include <QGpCoreMath.h>

namespace SciFigs {

  class GraphContentsOptions;

  class IrregularGrid2DDraw
  {
  public:
    inline IrregularGrid2DDraw();
    inline ~IrregularGrid2DDraw();

    void setVisibleArea(const IrregularGrid2D & grid, const GraphContentsOptions& gc);
    void setCellNodes(const IrregularGrid2D & grid, const GraphContentsOptions& gc);
    void setCellLimits();

    int startix, stopix;
    int startiy, stopiy;
    int nx, ny;
    int * nodex, * nodey;
    int * limx, * limy;
  };

  inline IrregularGrid2DDraw::IrregularGrid2DDraw()
  {
    limx=nullptr;
    limy=nullptr;
    nodex=nullptr;
    nodey=nullptr;
  }

  inline IrregularGrid2DDraw::~IrregularGrid2DDraw()
  {
    delete [] limx;
    delete [] limy;
    delete [] nodex;
    delete [] nodey;
  }


} // namespace SciFigs

#endif // IRREGULARGRID2DDRAW.H
