/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-11
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FONTSCALES_H
#define FONTSCALES_H

#include "SciFigsDLLExport.h"

namespace SciFigs {

  class GraphicObject;

  class SCIFIGS_EXPORT FontScales
  {
  public:
    FontScales() {}
    ~FontScales() {}

    void add(GraphicObject * obj, double value);
    const VectorList<double>& values(GraphicObject * obj) const;
    double value(GraphicObject * obj) const {return values(obj).first();}
  private:
    QHash<GraphicObject *, VectorList<double>> _values;
  };

} // namespace SciFigs

#endif // FONTSCALES_H

