/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-17
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef EXTERNALPLOTLINE2D_H
#define EXTERNALPLOTLINE2D_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT ExternalPlotLine2D : public AbstractLine
  {
    TRANSLATIONS("ExternalPlotLine2D")
  public:
    ExternalPlotLine2D() {}
    ExternalPlotLine2D(const ExternalPlotLine2D& o);

    AbstractLine * clone() const;
    void operator=(const AbstractLine& o);
    bool canCopy(const AbstractLine& o) const;

    int count() const {return _curve->count();}
    void clear() {_curve->clear();}
    void append() {_curve->append(Point2D());}
    void insert(int index) {_curve->insert(index, Point2D());}
    void removeLast() {_curve->remove(_curve->count()-1);}
    bool isSorted() const {return _curve->isSorted();}
    void checkSort() {_curve->checkSort();}
    void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
      _curve->indexRange(xMin, xMax, indexMin, indexMax);
    }
    Point point(int index, const CurvePointOptions *) const {return _curve->constAt(index);}
    void setX(int index, double v) {_curve->setX(index, v);}
    void setY(int index, double v, const CurvePointOptions *) {_curve->setY(index, v);}
    void setZ(int, double, const CurvePointOptions *) {}

    const Curve<Point2D> * curve() const {return _curve;}
    Curve<Point2D> * curve() {return _curve;}
    void setCurve(Curve<Point2D> * curve);
    void setCurve(Curve<Point2D> * curve, const Pen& pen, const Symbol& sym);
  protected:
    Curve<Point2D> * _curve;
  };

} // namespace SciFigs

#endif // EXTERNALPLOTLINE2D_H

