/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-26
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef EXPORTOPTIONS_H
#define EXPORTOPTIONS_H

#include <QGpCoreMath.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

  class AxisWindow;
  class GraphicSheet;

  class SCIFIGS_EXPORT ExportOptions
  {
  public:
    ExportOptions();
    ~ExportOptions();

    bool read(int& argc, char ** argv);
    static void help(ApplicationHelp * h);

    const QStringList& selectedObjects() const {return _selectedObjects;}
    const QString& exportFormat() const {return _exportFormat;}
    const QString& exportFile() const {return _exportFile;}
    int dpi() const {return _dpi;}
    bool preserveScales() const {return _preserveScales;}
    QString legendFile() const;
    QString colorMapFile() const;
    const QStringList& makeupObjectFiles() const {return _makeupObjectFiles;}
    const QStringList& appendLayerFiles() const {return _appendLayerFiles;}
    const QStringList& prependLayerFiles() const {return _prependLayerFiles;}

    void selectObjects(GraphicSheet * sheet) const;
    bool setLegend(GraphicSheet * sheet) const;
    bool setColorMap(GraphicSheet * sheet) const;
    void addLayers(GraphicSheet * sheet) const;
    void restoreMakeUp(GraphicSheet * sheet) const;
    void exportObjects(GraphicSheet * sheet) const;
    void exportGridValues(GraphicSheet * sheet) const;

    ColorMap firstColorMap() const;
  private:
    QString extractLayerName(QString& file);

    QString _exportFile, _exportFormat, _exportLayer;
    QString _exportFileGraph;
    int _dpi;
    bool _preserveScales;
    QStringList _selectedObjects;
    QStringList _legendFiles, _colorMapFiles;
    QStringList _legendLayers, _colorMapLayers;
    QStringList _makeupObjectFiles;
    QStringList _appendLayerFiles, _prependLayerFiles;
  };

} // namespace SciFigs

#endif // EXPORTOPTIONS_H
