/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-15
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ColorPaletteEditor.h"
#include "ListInterpole.h"

namespace SciFigs {

  /*!
    \class ColorPaletteEditor ColorPaletteEditor.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ColorPaletteEditor::ColorPaletteEditor(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setupUi(this);
    _palette=nullptr;
    setModels(ColorPaletteModels::instance()->list());
    QSettings& reg=CoreApplication::instance()->settings();
    model->setCurrentText(reg.value("CurrentColorPalette").toString());
  }

  /*!
    Description of destructor still missing
  */
  ColorPaletteEditor::~ColorPaletteEditor()
  {
    TRACE;
    QSettings& reg=CoreApplication::instance()->settings();
    reg.setValue("CurrentColorPalette", currentModel());
  }

  void ColorPaletteEditor::setCategoricalDefault()
  {
    TRACE;
    categorical->setChecked(true);
  }

  void ColorPaletteEditor::setModels(const QStringList& modelList)
  {
    TRACE;
    for(int i=0; i<modelList.count(); i++) {
      QFileInfo fi(modelList.at(i));
      ColorPalette * pal=ColorPaletteModels::loadPalette(fi.absoluteFilePath());
      if(pal) {
        QPixmap thumbnail(32, 20);
        QPainter p;
        p.begin(&thumbnail);
        QColor col;
        for(int j=0; j<32; j++) {
          guiColor(pal->color(j << 3), col);
          p.fillRect(j, 0, 1, 20, col);
        }
        p.end();
        model->addItem(QIcon(thumbnail), fi.fileName());
      }
    }
  }

  void ColorPaletteEditor::setPalette(AbstractColorPalette * pal)
  {
    TRACE;
    _palette=pal;
  }

  QString ColorPaletteEditor::currentModel()
  {
    return model->currentText();
  }

  void ColorPaletteEditor::on_interpole_clicked()
  {
    TRACE;
    ListInterpole * d=new ListInterpole(QApplication::activeWindow());
    emit beginPaletteChange();
    d->setColors(_palette->palette());
    Settings::getWidget(d);
    if(d->exec()==QDialog::Accepted) {
      Settings::setWidget(d);
      _palette->hsvInterpole(d->fromIndex(), d->toIndex());
    }
    emit endPaletteChange();
    delete d;
  }

  void ColorPaletteEditor::on_colorScale_clicked()
  {
    TRACE;
    ListInterpole * d=new ListInterpole(QApplication::activeWindow());
    emit beginPaletteChange();
    d->setColors(_palette->palette());
    Settings::getWidget(d);
    if(d->exec()==QDialog::Accepted) {
      Settings::setWidget(d);
      ColorPalette::Options options=ColorPalette::Continuous;
      if(categorical->isChecked()) {
        options|=ColorPalette::Categorical;
      }
      if(reversed->isChecked()) {
        options|=ColorPalette::Reversed;
      }
      _palette->generate(d->fromIndex(), d->toIndex(), currentModel(), options);
    }
    emit endPaletteChange();
    // After changing to make that palette is available in ColorPaletteModels
    QString credits=ColorPaletteModels::instance()->credits(currentModel());
    if(!credits.isEmpty()) {
      Message::information(MSG_ID, tr("Color palette credits"),
                           tr("Using palette '%1'\n\n").arg(currentModel())+credits, true);
    }
  }

  void ColorPaletteEditor::on_grayScale_clicked()
  {
    TRACE;
    emit beginPaletteChange();
    _palette->toGray();
    emit endPaletteChange();
  }

} // namespace SciFigs

