/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORMAPPROPERTIES_H
#define COLORMAPPROPERTIES_H

#include <QGpCoreMath.h>

#include "ui_ColorMapProperties.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT ColorMapProperties : public PropertyWidget, private Ui::ColorMapProperties
  {
    Q_OBJECT
  public:
    ColorMapProperties(QWidget * parent=nullptr);

    enum Properties {Map};

    void setColorMap(const ColorMap& m);
    ColorMap colorMap() const;
  private slots:
    void on_loadPalette_clicked();
    void on_savePalette_clicked();
    void on_linearValues_clicked();
    void on_logValues_clicked();
    void on_colorNumber_valueChanged(int);
    void beginPaletteChange();
    void endPaletteChange();
  private:
    virtual PropertyValue::WidgetType determineCustomWidgetType(int pid, QWidget * w, QWidget * label);
    virtual bool connectCustomWidget(PropertyValue & p);
    virtual QVariant customWidgetValue(PropertyValue & p);
    virtual bool setCustomWidget(PropertyValue &  p);

    ColorMap _current;
  };

} // namespace SciFigs

#endif // COLORMAPPROPERTIES_H
