/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <SciFigs.h>

#include "RefractionPlotProxy.h"
#include "RefractionLine.h"

namespace QGpGuiWave {

  /*!
    \class RefractionPlotProxy RefractionPlotProxy.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void RefractionPlotProxy::setXAxisProperties(Axis * a)
  {
    TRACE;
    a->setRange(0.0,100.0);
    a->setScaleType(Scale::Linear);
    a->setAutoTicks(true);
  }

  void RefractionPlotProxy::setYAxisProperties(Axis * a)
  {
    a->setRange(0.0,100.0);
    a->setUnitFactor(1000.0);
    a->setScaleType(Scale::Linear);
  }

  void RefractionPlotProxy::setCurve(AbstractLine * line, CurveProxy * proxy) const
  {
    TRACE;
    static_cast<RefractionProxy *>(proxy)->setCurve(&static_cast<RefractionLine *>(line)->curve());
  }

} // namespace QGpGuiWave
