/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-24
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MODALCURVEPROPERTIES_H
#define MODALCURVEPROPERTIES_H

#include <QGpGuiMath.h>

#include "QGpGuiWaveDLLExport.h"
#include "ModeDelegate.h"

namespace QGpGuiWave {

  class ModeSelector;

  class QGPGUIWAVE_EXPORT ModalCurveProperties : public CurvePropertiesWidget
  {
    Q_OBJECT
  public:
    ModalCurveProperties(QWidget * parent=nullptr);
    ~ModalCurveProperties();

    virtual void setProxy(CurveProxy *proxy);
    virtual void setEditable(bool e);

    void setModeType(Mode::Type t);
    void setDefaultModeIndex(int i);
    void setDefaultRingIndex(int i);
    Mode defaultMode() const;

    virtual void beginCurveChange();
    virtual void endCurveChange();
  private:
    QSplitter * _msSplitter;
    ModeSelector * _modes;
  };

} // namespace QGpGuiWave

#endif // MODALCURVEPROPERTIES_H
