/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-27
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreWave.h>
#include <SciFigs.h>

#include "ModalCurveBrowser.h"
#include "ModalCurveProperties.h"
#include "ModalPlotProxy.h"

namespace QGpGuiWave {

/*!
  \class ModalCurveBrowser ModalCurveBrowser.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ModalCurveBrowser::ModalCurveBrowser(QWidget * parent)
    : CurveBrowser(parent)
{
  TRACE;
  _type=Mode::Dispersion;
  setPlotProxy(new ModalPlotProxy);
}

/*!
  Description of destructor still missing
*/
ModalCurveBrowser::~ModalCurveBrowser()
{
  TRACE;
}

CurvePropertiesWidget * ModalCurveBrowser::createProperties()
{
  ModalCurveProperties * p=new ModalCurveProperties;
  p->setModeType(_type);
  return p;
}

/*!
  Use this function rather than CurveBrowser::setProxy().
*/
void ModalCurveBrowser::setProxy(ModalProxy * proxy)
{
  TRACE;
  CurveBrowser::setProxy(proxy);
}

/*!
  Use this function rather than CurveBrowser::initLayer().
*/
void ModalCurveBrowser::initLayer(LineLayer * curveLayer)
{
  TRACE;
  CurveBrowser::initLayer(curveLayer);
  // Restrict layer to plot only ModalLine
  ModalLine * l=new ModalLine;
  l->setPen(Pen(Qt::black, 0.6));
  l->setSymbol(Symbol(Symbol::Circle, 1.2, Pen(Qt::black, 0.0),
                      Brush(Qt::black, Qt::SolidPattern)));
  curveLayer->setReferenceLine(l);
}

/*!
  Not used by pick or usually loadMultiColumns
*/
ModalLine * ModalCurveBrowser::addCurve(const ModalCurve& curve)
{
  TRACE;
  ModalLine * line=static_cast<ModalLine *>(currentLayer()->addLine());
  line->setCurve(curve);
  line->setVisible(curve.isEnabled());
  addLine(line);
  if(line->curve().modes().isEmpty()) {
    Mode m=static_cast<ModalCurveProperties *>(properties(line))->defaultMode();
    line->curve().addMode(m);
  }
  return line;
}

void ModalCurveBrowser::addCurves(const QList<ModalCurve>& curves)
{
  TRACE;
  int curvesCount=count();
  for(QList<ModalCurve>::const_iterator it=curves.begin();it!=curves.end();it++) {
    addCurve(*it);
  }
  if(curvesCount==0) setLimits();
  emit curveModified();
}

QList<ModalCurve> ModalCurveBrowser::curves() const
{
  TRACE;
  QList<ModalCurve> l;
  QList<CurvePropertiesWidget *> cpl=CurveBrowser::curves();
  foreach(CurvePropertiesWidget * cp, cpl) {
    l.append(static_cast<ModalLine *>(cp->line())->curve());
    l.last().setEnabled(cp->line()->isVisible());
  }
  return l;
}

} // namespace QGpGuiWave
