/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-31
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PropertyCategory.h"
#include "PropertyWidget.h"
#include "PropertyTab.h"
#include "ExpandTabWidget.h"

namespace QGpGuiTools {

  uint PropertyCategory::_lastUniqueId=1;
  uint PropertyCategory::invalidId=0;

  uint PropertyCategory::uniqueId()
  {
    return _lastUniqueId++;
  }

  /*!
    \class PropertyCategory PropertyCategory.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  PropertyCategory::PropertyCategory()
  {
    _tabs=new PropertyTab *[PropertyTab::idCount()];
    for(uint i=0; i<PropertyTab::idCount(); i++) {
      _tabs[i]=nullptr;
    }
  }

  /*!
    Description of destructor still missing
  */
  PropertyCategory::~PropertyCategory()
  {
    for(uint i=0; i<PropertyTab::idCount(); i++) {
      delete _tabs[i];
    }
    delete [] _tabs;
  }

  PropertyTab * PropertyCategory::find(uint tab)
  {
    PropertyTab * pt=_tabs[tab];
    if(pt) {
      return pt;
    } else {
      return nullptr;
    }
  }

  void PropertyCategory::setEditor(ExpandTabWidget * editor)
  {
    for(uint i=0; i<PropertyTab::idCount(); i++) {
      PropertyTab * pt=_tabs[i];
      if(pt) {
        editor->addWidget(pt->title(), pt->widget());
      }
    }
  }

  PropertyTab * PropertyCategory::addTab(uint tab, QString title, PropertyWidget * w, PropertyItem * item)
  {
    PropertyTab * t=new PropertyTab;
    t->setTitle(title);
    t->setWidget(w);
    ASSERT(!_tabs[tab]);
    _tabs[tab]=t;
    t->addReference(item);
    return t;
  }

  void PropertyCategory::removeTab(uint tab, PropertyItem * item, ExpandTabWidget * editor)
  {
    PropertyTab * pt=_tabs[tab];
    if(pt) {
      pt->removeReference(item);
      if(!pt->hasReference()) {
        bool deleteTab=true;
        if(editor) {
          if(editor->isDocked(pt->widget()) ) {
            editor->takeWidget(pt->widget());
          } else {
            deleteTab=false;
          }
        }
        if(deleteTab) {
          delete pt;
          _tabs[tab]=nullptr;
        }
      }
    }
  }

  void PropertyCategory::setValues()
  {
    for(uint i=0; i<PropertyTab::idCount(); i++) {
      PropertyTab * pt=_tabs[i];
      if(pt) {
        pt->setValues();
      }
    }
  }

  bool PropertyCategory::isEmpty() const
  {
    for(uint i=0; i<PropertyTab::idCount(); i++) {
      PropertyTab * pt=_tabs[i];
      if(pt) {
        return false;
      }
    }
    return true;
  }

} // namespace QGpGuiTools
