/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTTAB_H
#define MULTIDOCUMENTTAB_H

#include <QtGui>

#include "QGpGuiToolsDLLExport.h"
#include "MultiDocumentSubWindow.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT MultiDocumentTab : public QMdiArea
  {
    Q_OBJECT
  public:
    MultiDocumentTab(QWidget * parent=nullptr);
    ~MultiDocumentTab();

    void setName(const QString& n);
    QString name() const;

    void addSubWindow(MultiDocumentSubWindow * w);
    void removeSubWindow(MultiDocumentSubWindow * w);

    inline MultiDocumentSubWindow * currentSubWindow();
    QAction * windowMenuAction() const {return _windowMenuAction;}

    QList<MultiDocumentSubWindow *> subWindowList() const;
    bool closeAllSubWindows();
  public slots:
    void activate();
    void moveSubWindow();
  signals:
    void activateRequested(QWidget *);
    void nameChanged();
  private:
    QAction * _windowMenuAction;
  };

  inline MultiDocumentSubWindow * MultiDocumentTab::currentSubWindow()
  {
    return static_cast<MultiDocumentSubWindow *>(QMdiArea::currentSubWindow());
  }

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTTAB_H
