/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-09-18
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LoopProgressWidget.h"
#include "Application.h"

namespace QGpGuiTools {

/*!
  \class LoopProgressWidget LoopProgressWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
LoopProgressWidget::LoopProgressWidget(QWidget *parent)
    : QWidget(parent)
{
  TRACE;
  QLayout * l=new QVBoxLayout(this);
  _message=new QLabel(this);
  l->addWidget(_message);
  _area=new QScrollArea(this);
  _area->setWidgetResizable(true);
  _area->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
  connect(_area->verticalScrollBar(), SIGNAL(sliderMoved(int)), this, SLOT(stopAutoScroll()));
  l->addWidget(_area);

  _layout=nullptr;
  _autoScroll=true;
}

/*!
  Description of destructor still missing
*/
LoopProgressWidget::~LoopProgressWidget()
{
  TRACE;
}

void LoopProgressWidget::setButtons(QToolButton * start, QToolButton * stop)
{
  TRACE;
  _start=start;
  _stop=stop;
  setRunning(false);

  QAction * a;
  QMenu * m=new QMenu(this);
  m->setTitle(tr("Job number"));
  _start->setMenu(m);

  int i=CoreApplication::instance()->maximumThreadCount();
  for(; i>0; i--) {
    a=new QAction(i==1 ? tr("1 job") : tr("%1 jobs").arg(i), this);
    a->setData(i);
    connect(a, SIGNAL(triggered()), this, SLOT(start()));
    m->addAction(a);
  }
}

void LoopProgressWidget::start()
{
  TRACE;
  QAction * a=qobject_cast<QAction *>(sender());
  if(a) {
    emit startJobs(a->data().toInt());
  }
}

void LoopProgressWidget::setLoop(const QGpCoreTools::ParallelLoop * loop)
{
  TRACE;
  // Clear all progress widgets
  delete _area->widget();
  _labelList.clear();
  _progressList.clear();
  // Create new ones
  QWidget * w=new QWidget(this);
  _area->setWidget(w);
  _layout=new QVBoxLayout(w);
  // We setup the maximum number of possible parallel threads
  // Effectively some of them might not start according to system load
  int nProgress=loop->progressCount();
  for(int i=0; i<nProgress; i++) {
    QLabel * l=new QLabel(w);
    _labelList.append(l);
    QVBoxLayout * progressLayout=new QVBoxLayout;
    progressLayout->addWidget(l);
    QProgressBar * p=new QProgressBar(w);
    _progressList.append(p);
    progressLayout->addWidget(p);
    progressLayout->setContentsMargins(0, 0, 0, 0);
    _layout->addLayout(progressLayout);
  }
  _layout->addStretch();
  connect(loop, SIGNAL(statusChanged(int, QString)), this, SLOT(setStatus(int, QString)));
  connect(loop, SIGNAL(progressInit(int, int)), this, SLOT(initProgress(int, int)));
  connect(loop, SIGNAL(progressChanged(int, int)), this, SLOT(setProgress(int, int)));

  setRunning(true);
}

void LoopProgressWidget::setRunning(bool r, const QString& message)
{
  TRACE;
  _start->setEnabled(!r);
  _stop->setEnabled(r);
  if(r) {
    if(message.isEmpty()) {
      _message->setText(tr("Running..."));
    } else {
      _message->setText(message);
    }
  } else {
    _message->setText(tr("Not running"));
  }
}

void LoopProgressWidget::setStatus(int processIndex, QString msg)
{
  if(processIndex<_labelList.count()) {
    QLabel * l=_labelList.at(processIndex);
    l->setText(msg);
  }
}

void LoopProgressWidget::initProgress(int processIndex, int maximumValue)
{
  if(processIndex<_progressList.count()) {
    QProgressBar * p=_progressList.at(processIndex);
    p->setValue(0);
    p->setMaximum(maximumValue);
    if(!_autoScroll && !p->visibleRegion().isEmpty()) {
      _autoScroll=true;
    }
    if(_autoScroll) {
      _area->ensureWidgetVisible(p);
    }
  }
}

void LoopProgressWidget::stopAutoScroll()
{
  _autoScroll=false;
}

void LoopProgressWidget::setProgress(int processIndex, int value)
{
  if(processIndex<_progressList.count()) {
    QProgressBar * p=_progressList.at(processIndex);
    p->setValue(value);    
  }
}

} // namespace QGpGuiTools
