/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-11
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLUMNTEXTWIDGET_H
#define COLUMNTEXTWIDGET_H

#include <QtWidgets>
#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace Ui {
  class ColumnTextWidget;
}

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ColumnTextWidget : public QWidget
{
  Q_OBJECT
public:
  ColumnTextWidget(QWidget * parent=nullptr);
  ~ColumnTextWidget();

  void setFileEngine(ColumnTextFile * f);
  ColumnTextFile * fileEngine() {return _fileEngine;}

  void setStandardTypes(const QStringList& t);
  void setTypes(const VectorList<int>& t) {_fileEngine->setTypes(t);}

  void restoreParserSettings();
  void saveParserSettings();
private slots:
  void on_parserName_editTextChanged(const QString& text);
  void on_linesBut_clicked();
  void on_columnsBut_clicked();
  void on_sectionsBut_clicked();
  void on_loadBut_clicked();
  void on_saveBut_clicked();
  void restoreColumnWidths();
  void parserFileChanged(const QString& pf);
signals:
  void typeChanged();
private:
  Ui::ColumnTextWidget * _ui;
  ColumnTextFile * _fileEngine;
  QString _restoreColumnWidth;
};

} // namespace QGpGuiTools

#endif // COLUMNTEXTWIDGET_H
