/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-14
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "ColumnTextDelegate.h"

namespace QGpGuiTools {

  /*!
    \class ColumnTextDelegate ColumnTextDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  QWidget * ColumnTextDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                             const QModelIndex & index) const
  {
    TRACE;
    switch (index.row()) {
    case 0: {
        QComboBox * w=createComboBox(parent);
        w->addItems(_types);
        connect(w, SIGNAL(activated(int)), this, SLOT(commitWidget()));
        return w;
      }
    case 1:
    case 2:
    case 3:
      return createLineEdit(parent);
    default:
      return nullptr;
    }
  }

} // namespace QGpGuiTools
