/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-17
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CheckComboBox.h"
#include "CheckComboBoxModel.h"

namespace QGpGuiTools {

  /*!
    \class CheckComboBox CheckComboBox.h
    \brief A combo box for setting flags with checkboxes

    Displays checkboxes and current text is a comma separated list of checked items.
  */

  /*!
    Description of constructor still missing
  */
  CheckComboBox::CheckComboBox(QWidget * parent)
    : QComboBox(parent)
  {
    TRACE;
    CheckComboBoxModel * model=new CheckComboBoxModel(this);
    setModel(model);
    connect(model, SIGNAL(valueChanged()), this, SLOT(setCurrentText()));

    QLineEdit* lineEdit=new QLineEdit(this);
    lineEdit->setReadOnly(true);
    setLineEdit(lineEdit);
    lineEdit->disconnect(this);
    setInsertPolicy(QComboBox::NoInsert);

    view()->installEventFilter(this);
    view()->window()->installEventFilter(this);
    view()->viewport()->installEventFilter(this);
    this->installEventFilter(this);
  }

  /*!
    Description of destructor still missing
  */
  CheckComboBox::~CheckComboBox()
  {
    TRACE;
  }

  void CheckComboBox::addItems(const QStringList& items)
  {
    static_cast<CheckComboBoxModel *>(model())->addItems(items);
  }

  void CheckComboBox::setCurrentItems(const QString& items)
  {
    static_cast<CheckComboBoxModel *>(model())->setCurrentItems(items);
  }

  QString CheckComboBox::currentText() const
  {
    return static_cast<CheckComboBoxModel *>(model())->currentText();
  }

  bool CheckComboBox::eventFilter(QObject *, QEvent *e)
  {
    switch (e->type()) {
    case QEvent::MouseButtonRelease: {
        QMouseEvent *m=static_cast<QMouseEvent *>(e);
        if(m->button()==Qt::LeftButton &&
           isVisible() &&
           view()->rect().contains(m->pos()) &&
           view()->currentIndex().isValid() &&
           (view()->currentIndex().flags() & Qt::ItemIsEditable) &&
           (view()->currentIndex().flags() & Qt::ItemIsEnabled)) {
          static_cast<CheckComboBoxModel *>(model())->toggleItem(view()->currentIndex().row());
          return true;
        }
        break;
      }
    default:
        break;
    }
    return false;
  }

  void CheckComboBox::setCurrentText()
  {
    CheckComboBoxModel * m=static_cast<CheckComboBoxModel *>(model());
    lineEdit()->setText(m->currentText());
    emit currentTextChanged(lineEdit()->text());
  }

} // namespace QGpGuiTools
