/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  QGpGuiMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ImageScalingPointModel.h"

namespace QGpGuiMath {

  /*!
    \class ImageScalingPointModel ImageScalingPointModel.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ImageScalingPointModel::ImageScalingPointModel(QObject * parent)
    : QAbstractTableModel(parent)
  {
    TRACE;
    _references=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  ImageScalingPointModel::~ImageScalingPointModel()
  {
    TRACE;
  }

  void ImageScalingPointModel::setReferenceList(QList<ImageLayer::ReferencePoint> * ref)
  {
    TRACE;
    beginResetModel();
    _references=ref;
    endResetModel();
  }

  int ImageScalingPointModel::rowCount(const QModelIndex&) const
  {
    TRACE;
    if(_references) {
      return _references->count();
    }
    return 0;
  }

  int ImageScalingPointModel::columnCount(const QModelIndex&) const
  {
    TRACE;
    return 5;
  }

  QVariant ImageScalingPointModel::data(const QModelIndex& index, int role) const
  {
    TRACE;
    const ImageLayer::ReferencePoint& p=_references->at(index.row());
    switch (role) {
    case Qt::DisplayRole:
      switch (index.column()) {
      case 0: return p.name();
      case 1: return p.image().x();
      case 2: return p.image().y();
      case 3: return p.real().x();
      case 4: return p.real().y();
      default: return QVariant();
      }
    default:
      return QVariant();
    }
  }

  bool ImageScalingPointModel::setData(const QModelIndex& index, const QVariant & value,
                                       int role)
  {
    TRACE;
    ImageLayer::ReferencePoint& p=(*_references)[index.row()];
    switch (role) {
    case Qt::EditRole:
      switch (index.column()) {
      case 0:
        p.setName(value.toString());
        return true;
      case 1:
        p.image().setX(value.toInt());
        return true;
      case 2:
        p.image().setY(value.toInt());
        return true;
      case 3:
        p.real().setX(value.toDouble());
        return true;
      case 4:
        p.real().setY(value.toDouble());
        return true;
      default:
        return false;
      }
    default:
      return false;
    }
  }

  QVariant ImageScalingPointModel::headerData(int section, Qt::Orientation orientation,
                                              int role) const
  {
    TRACE;
    switch (role) {
    case Qt::DisplayRole:
      if(orientation==Qt::Horizontal) {
        switch (section) {
        case 0: return tr("Name");
        case 1: return tr("Image X");
        case 2: return tr("Image Y");
        case 3: return tr("Real X");
        case 4: return tr("Real Y");
        default: return QVariant();
        }
      } else {
        return section + 1;
      }
    case Qt::ToolTipRole:
      if(orientation==Qt::Horizontal) {
        switch (section) {
        case 0: return tr("Name of the reference point.");
        case 1: return tr("X coordinate on the image (in pixels).");
        case 2: return tr("Y coordinate on the image (in pixels).");
        case 3: return tr("Real X coordinate (generally in m).");
        case 4: return tr("Real Y coordinate (generally in m).");
        default: return QVariant();
        }
      } else {
        return QVariant();
      }
    default:
      return QVariant();
    }
  }

  Qt::ItemFlags ImageScalingPointModel::flags (const QModelIndex&) const
  {
    return Qt::ItemIsEnabled | Qt::ItemIsEditable | Qt::ItemIsSelectable;
  }

  void ImageScalingPointModel::add(const QPoint& p)
  {
    TRACE;
    int n=_references->count();
    beginInsertRows(QModelIndex(), n, n);
    _references->append(ImageLayer::ReferencePoint());
    ImageLayer::ReferencePoint& pr=_references->last();
    pr.setName(tr("ref %1").arg(n));
    pr.setImage(p);
    endInsertRows();
  }

  void ImageScalingPointModel::remove(int index)
  {
    TRACE;
    beginRemoveRows(QModelIndex(), index, index);
    _references->removeAt(index);
    endRemoveRows();
  }

  void ImageScalingPointModel::setReal(int index, const Point2D& p)
  {
    TRACE;
    (*_references)[index].real()=p;
    emit dataChanged(ImageScalingPointModel::index(index, 3),
                     ImageScalingPointModel::index(index, 4));
  }

} // namespace QGpGuiMath

