/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-06
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "CurveBrowserItem.h"

namespace QGpGuiMath {

/*!
  \class CurveBrowserItem CurveBrowserItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!

*/
CurveBrowserItem::CurveBrowserItem(CurveProxy *proxy, QObject * parent)
  : QAbstractItemModel(parent)
{
  _proxy=proxy;
  _editable=true;
}

void CurveBrowserItem::beginCurveChange()
{
  TRACE;
  beginResetModel();
}

void CurveBrowserItem::endCurveChange()
{
  TRACE;
  endResetModel();
}

int CurveBrowserItem::rowCount(const QModelIndex &parent) const
{
  TRACE;
  if(!parent.isValid())
    return _proxy->sampleCount();
  return 0;
}

int CurveBrowserItem::columnCount(const QModelIndex & ) const
{
  TRACE;
  return _proxy->columnCount()+1;
}

QVariant CurveBrowserItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  if(index.column()==0) {
    switch (role) {
    case Qt::CheckStateRole:
      return _proxy->isValid(index.row()) ? Qt::Checked : Qt::Unchecked;
    case Qt::TextAlignmentRole:
      return (int)(Qt::AlignHCenter | Qt::AlignVCenter);
    default:
      return QVariant();
    }
  } else {
    switch (role) {
    case Qt::EditRole:
    case Qt::DisplayRole:
      return _proxy->columnValue(index.row(), index.column()-1);
    case Qt::TextAlignmentRole:
      return (int)(Qt::AlignRight | Qt::AlignVCenter);
    default:
      return QVariant();
    }
  }
}

bool CurveBrowserItem::setData (const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  if(index.column()==0) {
    switch (role) {
    case Qt::CheckStateRole:
      _proxy->setValid(index.row(), value.toInt()==Qt::Checked);
      emit dataChanged(createIndex(index.row(), 0), createIndex(index.row(), 5));
      return true;
    default:
      return false;
    }
  } else {
    switch (role) {
    case Qt::EditRole:
      _proxy->setColumnValue(index.row(), index.column()-1, value);
      emit dataChanged(index, index);
      return true;
    default:
      return false;
    }
  }
}

QVariant CurveBrowserItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    if(section==0)
      return tr("Valid");
    else
      return _proxy->columnTitle(section-1);
  } else {
    return section + 1;
  }
}

QModelIndex CurveBrowserItem::index (int row, int column, const QModelIndex & ) const
{
  TRACE;
  return createIndex(row, column);
}

Qt::ItemFlags CurveBrowserItem::flags (const QModelIndex & index) const
{
  if(index.column()==0) {
    if(_editable) {
      return Qt::ItemIsSelectable | Qt::ItemIsUserCheckable | Qt::ItemIsEnabled;
    } else {
      return Qt::ItemIsSelectable | Qt::ItemIsUserCheckable;
    }
  } else {
    if(_editable) {
      if(_proxy->isValid(index.row())) {
        return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;
      } else {
        return Qt::ItemIsSelectable;
      }
    } else {
      return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
    }
  }
}

} // namespace QGpGuiMath
