/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-07
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "CurveBrowserDelegate.h"
#include "CurveBrowserItem.h"

namespace QGpGuiMath {

  /*!
    \class CurveBrowserDelegate CurveBrowserDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    \fn CurveBrowserDelegate::CurveBrowserDelegate()
    Description of constructor still missing
  */

  QWidget * CurveBrowserDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem & option,
                                               const QModelIndex &index) const
  {
    TRACE;
    if(index.column()==0) {
      return ItemDelegate::createEditor(parent, option, index);
    } else {
      DoubleSpinBox * w=createDoubleSpinBox(parent);
      w->setMinimum(-std::numeric_limits<double>::infinity());
      w->setMaximum(std::numeric_limits<double>::infinity());
      return w;
    }
  }

} // namespace QGpGuiMath
