/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-03-05
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CoordinateConvert.h"

namespace QGpGuiMath {

  /*!
    \class CoordinateConvert CoordinateConvert.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  CoordinateConvert::CoordinateConvert(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    _copyMenu=nullptr;
    _utmZoneTouched=false;
    setupUi(this);
    connect(copyButton, SIGNAL(pressed()), this, SIGNAL(copyReference()));
    connect(utmZoneEdit, SIGNAL(currentIndexChanged(int)), this, SLOT(utmZoneTouched()));
    utmZoneEdit->addItems(UtmZone::names());
  }

  /*!
    Description of destructor still missing
  */
  CoordinateConvert::~CoordinateConvert()
  {
    TRACE;
    delete _copyMenu;
  }

  void CoordinateConvert::on_localProjection_toggled(bool checked)
  {
    TRACE;
    ref->setEnabled(checked);
  }

  CoordinateConvert::Projection CoordinateConvert::projection() const
  {
    TRACE;
    if(localProjection->isChecked()) {
      return Local;
    } else {
      return UniversalTransverseMercator;
    }
  }

  void CoordinateConvert::saveReference() const
  {
    return ref->save();
  }

  Point2D CoordinateConvert::reference() const
  {
    return ref->reference();
  }

  void CoordinateConvert::setReference(const Point2D& p)
  {
    TRACE;
    ref->setReference(p);
  }

  void CoordinateConvert::utmZoneTouched()
  {
    TRACE;
    _utmZoneTouched=true;
  }

  void CoordinateConvert::setUtmZone(const UtmZone &z)
  {
    TRACE;
    if(!_utmZoneTouched) {
      utmZoneEdit->blockSignals(true);
      utmZoneEdit->setCurrentText(z.toString());
      utmZoneEdit->blockSignals(false);
    }
  }

  UtmZone CoordinateConvert::utmZone()
  {
    UtmZone z;
    z.fromString(utmZoneEdit->currentText());
    return z;
  }

  void CoordinateConvert::popupCopyMenu(QMenu * m)
  {
    TRACE;
    delete _copyMenu;
    m->exec(mapToGlobal(copyButton->pos()+QPoint(copyButton->width(), 0)));
    copyButton->setDown(false);
    _copyMenu=m;
  }

} // namespace QGpGuiMath
