/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-08-06
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "TiltNode.h"
#include "TiltPath.h"

namespace QGpCoreWave {

/*!
  \class TiltNode TiltNode.h
  \brief Brief description of class still missing

  Store the left and right ray paths for a node (either a source or a receiver)
*/

/*!
  Description of constructor still missing
*/
TiltNode::TiltNode()
{
  TRACE;
  _leftPaths=0;
  _rightPaths=0;
}

/*!
  Description of destructor still missing
*/
TiltNode::~TiltNode()
{
  TRACE;
  delete [] _leftPaths;
  delete [] _rightPaths;
}

double TiltNode::x() const
{
  TRACE;
  return _leftPaths[0].origin();
}

void TiltNode::init(double x0, const RefractionDippingModel& model)
{
  TRACE;
  x0-=model.xLeft();
  initPaths(RefractionDippingModel::LeftToRight, _leftPaths, x0, model);
  initPaths(RefractionDippingModel::RightToLeft, _rightPaths, x0, model);
}

void TiltNode::initPaths(RefractionDippingModel::Direction dir, TiltPath *& paths,
                             double x0, const RefractionDippingModel& model)
{
  TRACE;
  double x, dt;
  paths=new TiltPath [model.layerCount()-1];
  for(int iPath=1;iPath<model.layerCount();iPath++) {
    paths[iPath-1].setDeepestLayer(iPath);
    paths[iPath-1].setOrigin(x0);
    //printf("left path[%i] at %i x %lg t %lg\n",iPath,0,x0,0.0);
    if(model.isCriticalLayer(dir, iPath)) {
      x=x0;
      for(int iLayer=1;iLayer<=iPath;iLayer++) {
        dt=model.propagate(dir, iLayer, iPath, x);
        //printf("left path[%i] at %i x %lg t %lg\n",iPath,iLayer,x,dt);
        paths[iPath-1].setIntercept(iLayer, x, dt);
      }
    }
    else paths[iPath-1].setIntercept(0, x0, std::numeric_limits<double>::infinity());
  }
}

} // namespace QGpCoreWave
