/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-27
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RESISTIVITY1DMODEL_H
#define RESISTIVITY1DMODEL_H

#include "QGpCoreWaveDLLExport.h"
#include "GeophysicalModel.h"
#include "Profile.h"

namespace QGpCoreWave {

  class QGPCOREWAVE_EXPORT Resistivity1DModel : public GeophysicalModel, private Profile
  {
  public:
    Resistivity1DModel() {}
    Resistivity1DModel(int layerCount) : Profile() {resize(layerCount);}
    Resistivity1DModel(const Resistivity1DModel& o) : GeophysicalModel(), Profile() {operator=(o);}
    Resistivity1DModel(const Profile& o) : GeophysicalModel(), Profile() {Profile::operator=(o);}

    void operator=(const Resistivity1DModel& o) {Profile::operator=(o);}

    virtual GeophysicalModel * clone() const {return new Resistivity1DModel(*this);}

    int layerCount() const {return Profile::count();}
    virtual bool isEmpty() const {return layerCount()==0;}

    inline void setDepth(int i, double d) {Profile::setDepth(i, d);}
    inline void setResistivity(int i, double v) {Profile::setValue(i, v);}

    Profile profile() const;
    const VectorList<double>& resistivities() const {return values();}
    VectorList<double>& resistivities() {return values();}
    const VectorList<double>& depths() const {return Profile::depths();}

    static QString formatHelp();
    virtual QString toString() const;
    virtual bool fromStream(QTextStream& s, QString * comments=0);
    virtual void toStream(QTextStream& s) const;

    class ResistivityContext : public GeophysicalContext
    {
    public:
      ResistivityContext();
      Resistivity1DModel * model() const {return static_cast<Resistivity1DModel *>(_model);}
      virtual QString helpCode() const;
    };

    virtual GeophysicalContext * expressionContext() const {return new ResistivityContext;}

    class ResistivityStorage : public ExpressionStorage
    {
    public:
      ResistivityStorage(ResistivityContext * context) {_context=context;}
      virtual bool isReadOnly() const {return false;}
    protected:
      ResistivityContext * _context;
    };

    class VariableN : public ResistivityStorage
    {
    public:
      VariableN(ResistivityContext * context) : ResistivityStorage(context) {}
      virtual bool isReadOnly() const {return true;}
      virtual QVariant value(const QString&) const;
      virtual void setValue(const QString&, const QVariant& ) {}
    };

    class VariableD : public ResistivityStorage
    {
    public:
      VariableD(ResistivityContext * context) : ResistivityStorage(context) {}
      virtual QVariant value(const QString& index) const;
      virtual void setValue(const QString&, const QVariant& );
    };

    class VariableRes : public ResistivityStorage
    {
    public:
      VariableRes(ResistivityContext * context) : ResistivityStorage(context) {}
      virtual QVariant value(const QString& index) const;
      virtual void setValue(const QString&, const QVariant& );
    };
  private:
    bool setValue(double& var, const StringSection& field, int iLayer, const QString& varName, bool optional);
  };

} // namespace QGpCoreWave

#endif // RESISTIVITY1DMODEL_H
