/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONPROXY_H
#define REFRACTIONPROXY_H

#include <QGpCoreMath.h>

#include "RefractionCurve.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class QGPCOREWAVE_EXPORT RefractionProxy : public CurveProxy
  {
    TRANSLATIONS("RefractionProxy")
  public:
    RefractionProxy() : CurveProxy() {_curve=0;}

    virtual QString tag() const {return "TravelTimeProxy";}

    virtual CurveProxy * clone() const {return new RefractionProxy;}

    CURVEPROXY_BASIC_DECLARATIONS(RefractionCurve)
    CURVEPROXY_ADVANCED_DECLARATIONS(RefractionProxy)
    CURVEPROXY_NAME_DECLARATIONS
    CURVEPROXY_LOG_DECLARATIONS

    int columnCount() const {return 4;}
    QString columnName(int col) const;
    QString columnUnit(int col) const;

    QVariant columnValue(int sample, int col) const;
    void setColumnValue(int sample, int col, const QVariant & value);

    int xAxisColumn() const {return 0;}
    int xAxisInverseColumn() const  {return -1;}
    int yAxisColumn() const {return 1;}
    int yAxisInverseColumn() const {return -1;}

    QStringList columnFileTypes() const;
    VectorList<int> defaultColumnFileTypes() const;
    VectorList<int> savedColumns() const;

    bool parse(ColumnTextIterator& it);
  private:
    CURVEPROXY_PRIVATE_DECLARATIONS(RefractionCurve, FactoryPoint)
  };

} // namespace QGpCoreWave

#endif // REFRACTIONPROXY_H

