/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  QGpCoreWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-09-29
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "OmnidirectionalArrayResponse.h"

namespace QGpCoreWave {

  /*!
    \class OmnidirectionalArrayResponse OmnidirectionalArrayResponse.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  OmnidirectionalArrayResponse::OmnidirectionalArrayResponse(const VectorList<Point2D>& stations)
  {
    _stations=stations;
    _fac=_stations.size();
    _fac=4.0*M_PI*M_PI/(_fac*_fac);
  }

  void OmnidirectionalArrayResponse::setWavenumber(double k)
  {
    _wavenumber=k;
    ComplexMatrix jr(_stations.size(), 1);
    for(int i=_stations.count()-1; i>=0; i--) {
      jr.at(i, 0)=j0(_wavenumber*_stations[i].length());
    }
    _crossSpectrum=jr*jr.conjugateTransposedVector();
    _crossSpectrum*=4.0*M_PI*M_PI;
    for(int i=_stations.count()-1; i>=0; i--) {
      _crossSpectrum.at(i, i)+=0.01;
    }
    _crossSpectrum.invert();
  }

  double OmnidirectionalArrayResponse::value(Vector<double>& k) const
  {
    //High resolution
    ComplexMatrix q(_stations.count(), 1);
    for(int i=_stations.count()-1; i>=0; i--) {
      q.at(i, 0).setUnitExp(-k.scalarProduct(_stations[i]));
    }
    ComplexMatrix m=q.conjugateTransposedVector()*_crossSpectrum*q;
    return 1.0/m.at(0, 0).re();
    //return m.at(0, 0).re();
    // Conventional
    /*Complex q;
    Complex B;
    for(int i=_stations.count()-1; i>=0; i--) {
      // Minus sign skipped... q or q*, it does not matter because abs2() is calculated.
      q.setUnitExp(k.scalarProduct(_stations[i]));
      q*=j0(_wavenumber*_stations[i].length());
      B+=q;
    }
    return B.abs2()*_fac;*/
  }

} // namespace QGpCoreWave

