/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MagnetoTelluricPointOptions.h"

namespace QGpCoreWave {

/*!
  \class MagnetoTelluricPointOptions MagnetoTelluricPointOptions.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

  /*!
  */
  double MagnetoTelluricPointOptions::toDouble(double x, const Complex& c) const
  {
    switch(_mode) {
    case ApparentResistivity:
      break;
    case AbsoluteValue:
      return c.abs();
    case PhaseDegrees:
      return c.phase()*180.0/M_PI;
    case PhaseRadians:
      return c.phase();
    case Real:
      return c.re();
    case Imaginary:
      return c.im();
    }
    return toApparentResistivity(x, c.abs());
  }

  /*!
  */
  void MagnetoTelluricPointOptions::fromDouble(double x, Complex& c, double v) const
  {
    switch(_mode) {
    case ApparentResistivity:
      c.setAbs(toAbsoluteValue(x, v));
      break;
    case AbsoluteValue:
      c.setAbs(v);
      break;
    case PhaseDegrees:
      c.setPhase(v*M_PI/180.0);
      break;
    case PhaseRadians:
      c.setPhase(v);
      break;
    case Real:
      c.setRe(v);
      break;
    case Imaginary:
      c.setIm(v);
      break;
    }
  }

} // namespace QGpCoreWave
