/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-24
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNETOTELLURICFACTORY_H
#define MAGNETOTELLURICFACTORY_H

#include "QGpCoreWaveDLLExport.h"
#include "MagnetoTelluricCurve.h"
#include "MagnetoTelluricPointOptions.h"

namespace QGpCoreWave {

  class Resistivity1DModel;

  class QGPCOREWAVE_EXPORT MagnetoTelluricFactory
  {
  public:
    MagnetoTelluricFactory();
    ~MagnetoTelluricFactory();

    void setX(const QList<MagnetoTelluricCurve>& curves);
    void linkX(QList<MagnetoTelluricCurve>& curves) const;
    void setX (const MagnetoTelluricCurve& c);
    void setX(const VectorList<double>& x);
    void linkX (MagnetoTelluricCurve& c) const;
    void setAngularFrequency();

    bool calculate(const Resistivity1DModel& model, double staticShift=1.0);

    void writeReport(QDataStream& s) const;
    void readReport(QDataStream& s);
    void toStream(QTextStream& sOut, const MagnetoTelluricPointOptions& options) const;

    const ComplexValue * impedanceXY() const {return _impedanceXY;}
    MagnetoTelluricCurve curve() const;
    const VectorList<double>& angularFrequencies() const {return _x;}
  private:
    VectorList<double> _x;
    ComplexValue * _impedanceXY;
  };

} // namespace QGpCoreWave

#endif // MAGNETOTELLURICFACTORY_H
