/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PARALLELTASKMANAGER_H
#define PARALLELTASKMANAGER_H

#include "ParallelLoop.h"
#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

  class ParallelTask;

  class QGPCORETOOLS_EXPORT ParallelTaskManager : public ParallelLoop
  {
  public:
    ParallelTaskManager();
    ~ParallelTaskManager();

    int progressCount() const {return _tasks.count();}

    void start(bool forceParallel=false);

    ParallelTask * nextFreshTask();
    void purgeTasks();
    ParallelTask * nextTask();
    ParallelTask * nextTaskToPolish();
    void showProgress();
  protected:
    void setTasks(int n);
    virtual ParallelTask * createTask(int taskIndex);
  private:
    using ParallelLoop::start;

    QReadWriteLock _taskLock;
    QList<ParallelTask *> _tasks;
    QMutex _polishMutex;
    QList<ParallelTask *> _tasksToPolish;
    QMutex _nextAvailableMutex;
    int _nextAvailableTask;
  };

} // namespace QGpCoreTools

#endif // PARALLELTASKMANAGER_H

