/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-01-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLECLASSIFICATIONPARAMETERS_H
#define SAMPLECLASSIFICATIONPARAMETERS_H

#include <QGpCoreTools.h>

#include "QGpCoreStatDLLExport.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT SampleClassificationParameters : public AbstractParameters
  {
  public:
    SampleClassificationParameters();
    SampleClassificationParameters(const SampleClassificationParameters& o);

    AbstractParameters * clone() const;

    enum Action {Reset, Invalidate, Validate, Categorize};
    enum ValueCondition {
                         NoCondition,
                         AbsoluteThreshold,
                         RelativeThreshold,
                         CurveAbsoluteInsideRange,
                         CurveRelativeInsideRange,
                         CurveStddevInsideRange,
                         CurveAbsoluteOutsideRange,
                         CurveRelativeOutsideRange,
                         CurveStddevOutsideRange,
                         AboveCurve,
                         BelowCurve,
                         InsideCurves,
                         OutsideCurves
                        };
    enum CategoryCondition {AllCategories, OneCategory, AllExceptOneCategory};

    ENUM_AS_STRING_DECL(ValueCondition)
    ENUM_AS_STRING_DECL(CategoryCondition)
    ENUM_AS_STRING_DECL(Action)

    ValueCondition valueConditionType() const {return _valueConditionType;}
    void setValueConditionType(const ValueCondition& c) {_valueConditionType=c;}

    CategoryCondition categoryConditionType() const {return _categoryConditionType;}
    void setCategoryConditionType(const CategoryCondition& c) {_categoryConditionType=c;}

    int categoryCondition() const {return _categoryCondition;}
    void setCategoryCondition(int c) {_categoryCondition=c;}

    inline bool matchCategory(int category) const;

    Action action() const {return _action;}
    void setAction(const Action& a) {_action=a;}

    int category() const {return _category;}
    void setCategory(int c) {_category=c;}

    double threshold() const {return _threshold;}
    void setThreshold(double t) {_threshold=t;}

    double absoluteRange() const {return _absoluteRange;}
    void setAbsoluteRange(double r) {_absoluteRange=r;}

    double relativeRange() const {return _relativeRange;}
    void setRelativeRange(double r) {_relativeRange=r;}

    double stddevRange() const {return _stddevRange;}
    void setStddevRange(double r) {_stddevRange=r;}

    const QString& curve1() const {return _curve1;}
    void setCurve1(const QString& c) {_curve1=c;}

    const QString& curve2() const {return _curve2;}
    void setCurve2(const QString& c) {_curve2=c;}

    const QString& fileParser() const {return _fileParser;}
    void setFileParser(const QString& p) {_fileParser=p;}

    const QString& file() const {return _file;}
    void setFile(const QString& f) {_file=f;}

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    Action _action;
    ValueCondition _valueConditionType;
    CategoryCondition _categoryConditionType;
    int _categoryCondition;
    double _threshold;
    double _absoluteRange;
    double _relativeRange;
    double _stddevRange;
    int _category;
    QString _curve1, _curve2, _fileParser, _file;
  };

  inline bool SampleClassificationParameters::matchCategory(int category) const
  {
    switch(_categoryConditionType) {
    case AllCategories:
      break;
    case OneCategory:
      return category==_categoryCondition;
    case AllExceptOneCategory:
      return category!=_categoryCondition;
    }
    return true;
  }

} // namespace QGpCoreStat

#endif // SAMPLECLASSIFICATIONPARAMETERS_H

