/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-06-16
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GAUSSIANMIXTUREEM_H
#define GAUSSIANMIXTUREEM_H

#include "QGpCoreStatDLLExport.h"
#include "GaussianMixtureDistribution.h"
#include "MultivariateHistogram.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT GaussianMixtureEM
  {
  public:
    GaussianMixtureEM();
    ~GaussianMixtureEM();

    void init(const MultivariateHistogram * h, int modeCount);
    void uniform(const Vector<double>& min,
                 const Vector<double>& max,
                 const Vector<double>& stddev);
    void iterate();
    GaussianMixtureDistribution& distribution() {return *_distribution;}
  private:
    const MultivariateHistogram * _histogram;
    GaussianMixtureDistribution * _distribution;
  };

} // namespace QGpCoreStat

#endif // GAUSSIANMIXTUREEM_H

