/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TRIANGLE_H
#define TRIANGLE_H

#include "Point2D.h"
#include "Circle.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Triangle
  {
  public:
    Triangle() {}
    inline Triangle(const Point2D& a, const Point2D& b, const Point2D& c);
    inline Triangle(const Triangle& o);

    const Point2D& vertex(int index) const {return _vertices[index];}
    Point2D& vertex(int index) {return _vertices[index];}

    Circle circumcircle(bool& ok) const;
    double surface() const;

    void super(const QList<Point2D>& points);

    bool hasEdge(const Point2D& p1, const Point2D& p2) const;
    bool hasVertex(const Point2D& p) const;
    bool hasSimilarVertex(const Point2D& p, double tolerance) const;
    bool hasSimilarEdge(const Point2D& p1, const Point2D& p2, double tolerance) const;
    bool isNeighbor(const Triangle& o) const;

    QString toString(char format='g', int precision=6) const;
  private:
    Point2D _vertices[3];
  };

  inline Triangle::Triangle(const Point2D& a, const Point2D& b, const Point2D& c)
  {
    _vertices[0]=a;
    _vertices[1]=b;
    _vertices[2]=c;
  }

  inline Triangle::Triangle(const Triangle& o)
  {
    _vertices[0]=o._vertices[0];
    _vertices[1]=o._vertices[1];
    _vertices[2]=o._vertices[2];
  }


} // namespace QGpCoreMath

#endif // TRIANGLE_H

