/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-09-15
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Misfit.h"

namespace QGpCoreMath {

  /*!
    \class Misfit Misfit.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  ENUM_AS_STRING_BEGIN(Misfit, Type)
  ENUM_AS_STRING_DATA_13(Akaike, AkaikeFewSamples, Determinant, L1, L1_LogNormalized,
                         L1_Normalized, L1_NormalizedBySigmaOnly, L2, L2_Inverse,
                         L2_LogNormalized, L2_Normalized, L2_NormalizedBySigmaOnly, RMS);
  ENUM_AS_STRING_END


  QStringList Misfit::types()
  {
    QStringList list;
    for(int i=L1; i<TypeCount; i++) {
      list.append(convertType(static_cast<Type>(i)));
    }
    std::sort(list.begin(), list.end());
    return list;
  }

} // namespace QGpCoreMath

