/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-03-03
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FunctionPlot.h"

namespace QGpCoreMath {

  /*!
    \class FunctionPlot FunctionPlot.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  FunctionPlot::FunctionPlot(int xSize, AbstractFunction * f)
    : _x(xSize, 0.0)
  {
    _function=f;
  }

  /*!
    Description of destructor still missing
  */
  FunctionPlot::~FunctionPlot()
  {
    delete _function;
  }

  void FunctionPlot::setFunction(AbstractFunction * f)
  {
    if(f!=_function) {
      delete _function;
      _function=f;
    }
  }

  double FunctionPlot::value(double x, double y) const
  {
    _x[0]=x;
    _x[1]=y;
    return function()->value(_x);
  }

} // namespace QGpCoreMath

