/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-25
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FREQUENCYCURVEPROXY_H
#define FREQUENCYCURVEPROXY_H

#include "RealStatisticalProxy.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT FrequencyCurveProxy : public RealStatisticalProxy
  {
    TRANSLATIONS("FrequencyCurveProxy")
  public:
    QString tag() const {return "FrequencyCurveProxy";}

    CurveProxy * clone() const {return new FrequencyCurveProxy;}

    int columnCount() const {return 5;}
    QString columnName(int col) const;
    QString columnUnit(int col) const;

    QVariant columnValue(int sample, int col) const;
    void setColumnValue(int sample, int col, const QVariant & value);

    int xAxisColumn() const {return 0;}
    int xAxisInverseColumn() const  {return 1;}
    int yAxisColumn() const {return 2;}
    int yAxisInverseColumn() const {return -1;}

    QStringList columnFileTypes() const;
    VectorList<int> defaultColumnFileTypes() const;
    VectorList<int> savedColumns() const;

    bool parse(ColumnTextIterator& it);
  };

} // namespace QGpCoreMath

#endif // FREQUENCYCURVEPROXY_H

