/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CurveProxy.h"

namespace QGpCoreMath {

  /*!
    \class CurveProxy CurveProxy.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  bool CurveProxy::isAbove(const CurveProxy * o, const CurvePointOptions * pointOptions,
                           SamplingOptions xSampling, SamplingOptions ySampling) const
  {
    double yo, dyo;
    bool matchingRange=false;
    for(int i=sampleCount()-1; i>=0; i--) {
      if(o->isInsideRange(x(i))) {
         matchingRange=true;
         o->interpole(x(i), yo, dyo, pointOptions, xSampling, ySampling);
         if(y(i, pointOptions)<=yo) {
           return false;
         }
      }
    }
    return matchingRange;
  }

  /*!
    Returns the title for column \a col.
  */
  QString CurveProxy::columnTitle(int col) const
  {
    TRACE;
    QString t=columnName(col);
    if(!t.isEmpty()) {
      QString unit=columnUnit(col);
      if(!unit.isEmpty()) {
        t+=" ("+unit+")";
      }
    }
    return t;
  }

  /*!

  */
  void CurveProxy::save(QTextStream& s)
  {
    TRACE;
    VectorList<int> cols=savedColumns();
    QString logTmp=log();
    logTmp.replace("\n","\n# ");
    s << "# Curve name:" << name() << "\n"
         "# Begin curve log\n"
         "# " << logTmp << "\n"
         "# End curve log\n"
         "# | ";
    for(VectorList<int>::iterator it=cols.begin();it!=cols.end();it++) {
      s << columnTitle(*it) << " | ";
    }
    s << "\n";
    int n=sampleCount();
    for(int i=0;i < n;i++ ) {
      for(VectorList<int>::iterator it=cols.begin();it!=cols.end();it++) {
        s << columnValue(i, *it).toString() << " ";
      }
      if(isValid(i)) {
        s << "1";
      } else {
        s << "0";
      }
      s << "\n";
    }
  }

  void CurveProxy::setComments(QString c)
  {
    QTextStream s(&c, QIODevice::ReadOnly);
    bool readingLog=false;
    while(!s.atEnd()) {
      QString line=s.readLine();
      if(readingLog) {
        if(line=="# End curve log") {
          return;
        }
        addLog(line.mid(2)+"\n");
      } else if(line.startsWith("# Curve name:")) {
        setName(line.mid(13));
      } else if(line=="# Begin curve log") {
        readingLog=true;
      }
    }
  }

  void CurveProxy::beginSplit(double, SamplingOptions,
                              double, int)
  {

  }

  int CurveProxy::splitCount() const
  {
    return 0;
  }

  void CurveProxy::getSplit(const CurveProxy * , int)
  {

  }

  void CurveProxy::endSplit()
  {

  }

} // namespace QGpCoreMath

