/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-11-26
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COVARIANCE_H
#define COVARIANCE_H

#include "QGpCoreMathDLLExport.h"
#include "DoubleMatrix.h"
#include "Ellipse.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Covariance
  {
  public:
    Covariance(int n);
    ~Covariance();

    void add(double * val);
    void reset();

    DoubleMatrix matrix() const;
    int count() const {return _count;}
    Ellipse stddev2D() const;
    double mean(int i) const {return _sums[i]/_count;}
  private:
    double * _xProducts;
    double * _sums;
    int _n, _nx, _count;
  };

} // namespace QGpCoreMath

#endif // COVARIANCE_H
