/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-01-13
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ComplexMPMatrix.h"
#include "Random.h"

#ifdef MULTI_PRECISION

namespace QGpCoreMath {

  /*!
    \class ComplexMPMatrix ComplexMPMatrix.h
    \brief Brief description of class still missing

    By default construct a 128-bit precsion matrix
  */

  void ComplexMPMatrix::setPrecision(int nbits)
  {
    ComplexMP * v=values();
    for(int i=rowCount()*columnCount()-1; i>=0; i--) {
      v[i].setPrecision(nbits);
    }
    _precision=nbits;
  }

  void ComplexMPMatrix::resize(int ndim)
  {
    Matrix<ComplexMP>::resize(ndim);
    setPrecision(_precision);
  }

  void ComplexMPMatrix::resize(int nrow, int ncol)
  {
    Matrix<ComplexMP>::resize(nrow, ncol);
    setPrecision(_precision);
  }

  void ComplexMPMatrix::rand()
  {
    Random r;
    ComplexMP * values=ComplexMPMatrix::values();
    for(int i=columnCount()*rowCount()-1; i>=0; i--) {
      values[i]=ComplexMP(_precision, r.ran2(), r.ran2());
    }
  }

} // namespace QGpCoreMath

#endif // MULTI_PRECISION

