/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-08
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTE_H
#define COLORPALETTE_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class ColorPaletteModels;

  class QGPCOREMATH_EXPORT ColorPalette
  {
  public:
    ColorPalette();
    ColorPalette(const ColorPalette& o);
    ~ColorPalette();

    void operator=(const ColorPalette& o);
    bool operator==(const ColorPalette& o) const;

    QString toString() const;
    bool fromString(const QString& s);

    void resize(int n);
    int count() const {return _n;}

    const Color& color(int index) const {return _colors[index];}
    Color& color(int index) {return _colors[index];}
    void setColor(int index, const Color& c) {_colors[index]=c;}

    enum Option {Continuous=0, Categorical=1, Reversed=2};
    Q_DECLARE_FLAGS(Options, Option)
    ENUM_AS_STRING_DECL(Option)

    void generate(int imin, int imax, const QString& model=defaultSequential,
                  Options options=Continuous, quint16 transparency=COLOR_COMPONENT_MAX);
    void setWhiteTransparent(bool b);

    void sardineGrayScale(int imin, int imax);
    void hsv(int n, int sat=255, int value=255, int transparency=255);

    void rgbInterpole(int imin, int imax);
    void hsvInterpole(int imin, int imax);

    void toGray();

    static ColorPalette preference(const QString& name, int n,
                                   const QString& model=defaultSequential,
                                   Options options=Continuous,
                                   quint16 transparency=COLOR_COMPONENT_MAX);
    static void setPreference(const QString& name, const ColorPalette& pal);

    static const QString defaultSequential;
    static const QString defaultSequentialWhite;
    static const QString defaultDiverging;
    static const QString defaultMultiSequential;
    static const QString defaultCyclic;
    static const QString defaultCategorical;
  private:
    Color color(double index) const;

    int _n;
    Color * _colors;
  };

} // namespace QGpCoreMath

#endif // COLORPALETTE_H

