/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-05-12
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef Circle_H
#define Circle_H

#include "Point2D.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT Circle
{
public:
  Circle(double x0=0.0, double y0=0.0, double r=0.0);
  Circle(const Point2D& c, double r);
  Circle(const Point2D& p1, const Point2D& p2, const Point2D& p3);

  const Point2D& center() const {return _c;}
  double radius() const {return _r;}

  VectorList<Point2D> intersect(const Circle& o) const;
  Point2D intersect(const Circle& o, bool& ok, const Circle& disc) const;
  double distanceTo(const Point2D& p) const;
  bool contains(const Point2D& p, double relativeTolerance=1.0) const;
  bool squareContains(const Point2D& p, double relativeTolerance=1.0) const;
private:
  Point2D _c;
  double _r;
};

} // namespace QGpCoreMath

#endif // CIRCLE_H
