/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-09-23
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SUMMARYMAPOPTIONS_H
#define SUMMARYMAPOPTIONS_H

#include <SciFigs.h>

#include "ui_SummaryMapOptions.h"
#include "HVGuiDLLExport.h"
#include "AbstractSummary.h"

namespace HVGui {

class HVGUI_EXPORT SummaryMapOptions : public QWidget, private Ui::SummaryMapOptions
{
  Q_OBJECT
public:
  SummaryMapOptions(QWidget * parent=nullptr);
  ~SummaryMapOptions();

  void setCategories(const Legend& c) {_categories=c;}
  void setLabels(StationLine::Label l);
  void setPeakSelection(StationLine::PeakSelection v);
  void setPeakValue(CurveResults::PeakValue v);
  void setPeakValueDecimals(int d);
  void setPeakIndex(int index);
  void setShowBubbles(bool b);

  const Legend& categories() const {return _categories;}
  StationLine::Label labels() const;
  StationLine::PeakSelection peakSelection() const;
  CurveResults::PeakValue peakValue() const;
  int peakValueDecimals() const;
  int peakIndex() const;
  bool showBubbles() const;
signals:
  void touched();
private slots:
  void on_peakNumber_toggled(bool checked);
  void on_categoryLegend_clicked();
  void on_labelPeakValue_toggled(bool checked);
  void commit();
private:
  Legend _categories;
  LegendProperties * _legendProperties;
};

} // namespace HVGui

#endif // SUMMARYMAPOPTIONS_H
