/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STUDENTTEST_H
#define STUDENTTEST_H

#include <QGpGuiTools.h>
#include <HVCore.h>

#include "AbstractResultSheet.h"
#include "ui_StudentTest.h"

namespace HVGui {

  class StudentTest: public Dialog, private Ui::StudentTest
  {
    Q_OBJECT
  public:
    StudentTest(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    typedef QMap<QString, QList<CurveResults *>> ResultLists;

    void init(const ResultLists& curves);

    CurveResults * firstCurve() const;
    CurveResults * secondCurve() const;
    double significance() const {return significanceEdit->value();}
    QString makeUp() const {return makeUpFile->text();}
  private slots:
    void on_makeUpBrowse_clicked();
  };

} // namespace HVGui

#endif // STUDENTTEST_H
