/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-04
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVERESULTWIDGET_H
#define CURVERESULTWIDGET_H

#include "AbstractResultWidget.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT CurveResultWidget : public AbstractResultWidget
  {
    Q_OBJECT
  public:
    CurveResultWidget(QWidget * parent=nullptr);
    ~CurveResultWidget();

    void setValueTitle(const QString& t);
    const QString& valueTitle() const;

    void restoreMakeUp(const QString& fileName);

    void setPetersonNoiseModel(const SamplingParameters &sampling, const QString &unit);

    void setValues(AbstractResults * res);
    CurveResults * values() const {return static_cast<CurveResults *>(_values);}
    void showValues();

    void setLimits(const SamplingParameters& x, double maxY);
    double maximumY() const;

    ParallelBands * t10Layer() const {return _t10Layer;}
    ParallelBands * peakLayer() const {return _peakLayer;}
    XUniqueYColorLines * windowsLayer() const {return _windowsLayer;}
    LineLayer * averageLayer() const {return _averageLayer;}
    LineLayer * stddevLayer() const {return _stddevLayer;}
    LineLayer * noiseModelLayer() const {return _noiseModelLayer;}

    static void addFrequencyBands(ParallelBands * layer, const CurveResults * res, int index);
  signals:
    void peakChanged();
  private:
    ParallelBands * _t10Layer;
    ParallelBands * _peakLayer;
    XUniqueYColorLines * _windowsLayer;
    LineLayer * _averageLayer;
    LineLayer * _stddevLayer;
    LineLayer * _noiseModelLayer;
  };

} // namespace HVGui

#endif // CURVERESULTWIDGET_H

