/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-06-22
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef AVERAGEPEAKMODEL_H
#define AVERAGEPEAKMODEL_H

#include <HVCore.h>

#include "AbstractPeakModel.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT AveragePeakModel : public AbstractPeakModel
  {
  public:
    AveragePeakModel(const QList<CurveResults *> * results,
                     const VectorList<RealStatisticalValue>& peaks,
                     QObject * parent=nullptr);
    ~AveragePeakModel();

    void add(double min, double max);
    void adjust(int index, double min, double max);
    void remove(int index);
    void save(QTextStream& s, int index);

    RealStatisticalValue peak(double min, double max);
    const VectorList<RealStatisticalValue>& peaks() const {return _peaks;}

    int rowCount(const QModelIndex &parent=QModelIndex()) const;
    int columnCount(const QModelIndex &parent=QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  private:
    const QList<CurveResults *> * _res;
    VectorList<RealStatisticalValue> _peaks;
  };

} // namespace HVGui

#endif // AVERAGEPEAKMODEL_H

