/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "AbstractResultWidget.h"

namespace HVGui {

  /*!
    \class AbstractResultWidget AbstractResultWidget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  AbstractResultWidget::AbstractResultWidget(QWidget * parent)
    : GraphicObjectGroup(parent)
  {
    TRACE;
    setRemovable(false);
    _label=new TextEdit;
    _label->setObjectName("label");
    _label->setAnchor(GraphicObject::BottomRight);
    _label->setGeometry(9.0, 1.0, 4.0, 0.5);
    addObject(_label);
  }

  /*!
    Description of destructor still missing
  */
  AbstractResultWidget::~AbstractResultWidget()
  {
    TRACE;
  }

  void AbstractResultWidget::setValueTitle(const QString& t)
  {
    Q_UNUSED(t);
  }

  void AbstractResultWidget::setValues(AbstractResults * res)
  {
    TRACE;
    _values=res;

    QString name=_values->name();
    setObjectName("group"+name);
    _label->setText(name);
    _label->update();  // Forces size adjustment
    _label->updateGeometry();
  }

  void AbstractResultWidget::setCategory(const QString& c)
  {
    TRACE;
    _values->setCategory(c);
    if(c.isEmpty()) {
      _label->setText(_values->name());
    } else {
      _label->setText(tr("[%1] %2").arg(c).arg(_values->name()));
    }
  }

} // namespace HVGui

