/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-17
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTHVWIDGET_H
#define ABSTRACTHVWIDGET_H

#include <HVCore.h>
#include <GeopsyGui.h>

#include "HVGuiDLLExport.h"
#include "ui_AbstractHVWidget.h"

#define _winResults static_cast<AbstractResultSheet*>(_childrenList[0])
#define _summary static_cast<AbstractSummary*>(_childrenList[1])

namespace HVGui {

  class AbstractResultSheet;
  class AbstractSummary;

  class HVGUI_EXPORT AbstractHVWidget : public AbstractToolWidget, public Ui::AbstractHVWidget
  {
    Q_OBJECT
  public:
    AbstractHVWidget(QWidget * parent);
    ~AbstractHVWidget();

    bool setSubPool(SubSignalPool * subPool);
    void endSignalChange(Signal * sig);

    AbstractHVTool * tool() {return static_cast<AbstractHVTool *>(_tool);}
    const AbstractHVTool * tool() const {return static_cast<const AbstractHVTool *>(_tool);}
  public slots:
    void start(int threadCount=0);
    void stop();
  protected slots:
    void setCurrentDisplayStation();
    void updateNofWindows();
    void updateSummary();
    void forceReprocess();
    void finish();
  private slots:
    void autoWindows();
    void beginAddWindowsManually();
    void endAddWindowsManually();
    void manualAddWindows(const Signal * sig, const TimeRange& r);
    void beginRemoveWindowsManually();
    void endRemoveWindowsManually();
    void manualRemoveWindows(const Signal * sig, const TimeRange& r);
    void inverseWindows();
    void clearWindows();
    void loadWindows(QStringList fileNames=QStringList());

    void on_azimuth_toggled();
    void on_makeUpResultsBrowse_clicked();
    void on_makeUpSummaryBrowse_clicked();
    void on_useMakeUpResults_toggled();
    void on_useMakeUpSummary_toggled();
    void on_doOversampling_toggled();
    void on_doHighPass_toggled();

    void winParamChanged();
    void procParamChanged();
  protected:
    void setMakeUp();
    void removeHorizontalComponents();
    void removeRotateStep();
    void parametersToGui();
    void parametersFromGui();
    void setWinParamChanged(bool c);
    void createResults(QString subPoolName);
    virtual void restoreFields();
    virtual void updateAllFields();

    virtual AbstractResultSheet * createResultSheet()=0;
    virtual AbstractSummary * createSummary()=0;
    virtual void setLimits();
    AbstractStation * belongsTo(const Signal * sig);
    void windowsChanged();
    QList<AbstractStation *> selectedStations();
  private:
    int countTimeWindows() const;
    double samplingPeriod();
    bool hasWindows();

    bool _forceReProcessAll;
  };

} // namespace HVGui

#endif // ABSTRACTHVWIDGET_H
