/***************************************************************************
**
**  This file is part of GeopsySLinkGui.
**
**  GeopsySLinkGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLinkGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QtGui>
#include <GeopsySLink.h>
#include "SeedLinkStreamItem.h"

namespace GeopsySLinkGui {

/*!
  \class SeedLinkStreamItem SeedLinkStreamItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SeedLinkStreamItem::SeedLinkStreamItem(QObject * parent)
    : QAbstractItemModel(parent)
{
  TRACE;
  _server=0;
}

/*!
  Description of destructor still missing
*/
SeedLinkStreamItem::~SeedLinkStreamItem()
{
  TRACE;
}

void SeedLinkStreamItem::setServer(const SeedLinkServer * s)
{
  TRACE;
  beginResetModel();
  _server=s;
  endResetModel();
}

int SeedLinkStreamItem::rowCount(const QModelIndex &parent) const
{
  TRACE;
  if(!_server) return 0;
  if(!parent.isValid()) return _server->count();
  if(isStation(parent)) return _server->at(parent.row())->count();
  return 0;
}

int SeedLinkStreamItem::columnCount(const QModelIndex & ) const
{
  TRACE;
  return 9;
}

bool SeedLinkStreamItem::isStation(const QModelIndex& index) const
{
  TRACE;
  return static_cast<XMLClass *>(index.internalPointer())->xml_tagName()==SeedLinkStation::xmlSeedLinkStationTag;
}

SeedLinkStation * SeedLinkStreamItem::station(const QModelIndex& index) const
{
  TRACE;
  return static_cast<SeedLinkStation *>(index.internalPointer());
}

bool SeedLinkStreamItem::isStream(const QModelIndex& index) const
{
  TRACE;
  return static_cast<XMLClass *>(index.internalPointer())->xml_tagName()==SeedLinkStream::xmlSeedLinkStreamTag;
}

SeedLinkStream * SeedLinkStreamItem::stream(const QModelIndex& index) const
{
  TRACE;
  return static_cast<SeedLinkStream *>(index.internalPointer());
}

QVariant SeedLinkStreamItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  if( !index.isValid()) return QVariant();
  if(isStream(index)) {
    SeedLinkStream * s=stream(index);
    switch (role) {
    case Qt::DisplayRole:
      switch (index.column()) {
      case 0: return s->location();
      case 1: return s->seedName();
      case 2: return s->type();
      case 3: return s->beginTime();
      case 4: return s->endTime();
      case 5: return s->beginRecNo();
      case 6: return s->endRecNo();
      case 7: return s->gapCheck();
      case 8: return s->gapThreshold();
      default: return QVariant();
      }
    case Qt::DecorationRole:
      switch (index.column()) {
      case 0: return s->listening() ? QPixmap( ":update_available.png" ) : QVariant();
      default: return QVariant();
      }
    case Qt::ToolTipRole:
      switch (index.column()) {
      case 1: return tr("Stream name");
      case 2: return tr("Type (D=data)");
      default: return QVariant();
      }
    default:
      return QVariant();
    }
  } else {
    SeedLinkStation * s=station(index);
    switch (role) {
    case Qt::DisplayRole:
      switch (index.column()) {
      case 0: return s->network()+"_"+s->name()+" ("+s->description()+")"+(s->streamCheck() ? " checked" : "");
      default: return QVariant();
      }
    case Qt::BackgroundRole:
      return QColor(Qt::lightGray);
    default:
      return QVariant();
    }
  }
}

QVariant SeedLinkStreamItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(orientation==Qt::Horizontal) {
    switch (role) {
    case Qt::DisplayRole:
      switch (section) {
      case 0: return tr("Location");
      case 1: return tr("Seed name");
      case 2: return tr("Type");
      case 3: return tr("Begin time");
      case 4: return tr("End time");
      case 5: return tr("Begin recno");
      case 6: return tr("End recno");
      case 7: return tr("Gap check");
      case 8: return tr("Gap treshold");
      default: return QVariant();
      }
    default:
      return QVariant();
    }
  } else
    return QVariant();
}

QModelIndex SeedLinkStreamItem::parent (const QModelIndex & index) const
{
  TRACE;
  if(!index.isValid()) return QModelIndex();
  if(isStream(index)) {
    SeedLinkStream * str=stream(index);
    SeedLinkStation * sta=str->station();
    return createIndex(_server->indexOf(sta), 0, sta);
  } else {
    return QModelIndex();
  }
}

QModelIndex SeedLinkStreamItem::index (int row, int column, const QModelIndex & parent) const
{
  TRACE;
  if(row<0) {
    return QModelIndex();
  }
  if(!parent.isValid()) {
    return createIndex(row, column, const_cast<SeedLinkStation *>(_server->at(row)));
  } else {
    const SeedLinkStation * station=_server->at(parent.row());
    return createIndex(row, column, const_cast<SeedLinkStream *>(station->at(row)));
  }
}

} // namespace GeopsySLinkGui
