/***************************************************************************
**
**  This file is part of GeopsySLink.
**
**  GeopsySLink is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsySLink is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-24
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SEEDLINKSERVER_H
#define SEEDLINKSERVER_H

#include <QGpCoreTools.h>
#include <GeopsyCore.h>
#include "GeopsySLinkDLLExport.h"

namespace GeopsySLink {

class SeedLinkStation;

class GEOPSYSLINK_EXPORT SeedLinkServer : public XMLClass, private QList<SeedLinkStation *>
{
public:
  SeedLinkServer() {_db=0;}
  ~SeedLinkServer();

  virtual const QString& xml_tagName() const {return xmlSeedLinkServerTag;}
  static const QString xmlSeedLinkServerTag;

  virtual void xml_attributes(XML_ATTRIBUTES_ARGS) const;
  virtual bool xml_setAttributes(XML_SETATTRIBUTES_ARGS);

  void setDatabase(SignalDatabase * db) {_db=db;}
  SignalDatabase * database() const {return _db;}

  QString software() const {return _software;}
  QString organization() const {return _organization;}
  QString beginTime() const {return _beginTime;}

  void addStation(SeedLinkStation * station) {append(station);}
  int indexOf(SeedLinkStation * station) const {return QList<SeedLinkStation *>::indexOf(station);}
  QList<int> indexOf(QRegularExpression networkStation) const;
  const SeedLinkStation * at(int index) const {return QList<SeedLinkStation *>::at(index);}
  int count() const {return QList<SeedLinkStation *>::count();}
  void clear();

  SubSignalPool allSignals() const;
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polish(XML_POLISH_ARGS);
private:
  SignalDatabase * _db;
  QString _software;
  QString _organization;
  QString _beginTime;
};


} // namespace GeopsySLink

#endif // SEEDLINKSERVER_H
