/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-21
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifdef HAS_PYTHON
#include "ActionRequest.h"

#include <QGpCoreTools.h>

#include "ActionExecute.h"

/*!
  \class ActionRequest ActionRequest.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ActionRequest::ActionRequest()
  : QObject(nullptr)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
ActionRequest::~ActionRequest()
{
  TRACE;
}

void ActionRequest::connectTo(ActionExecute * a)
{
  connect(this, SIGNAL(requestCreateGraphicSheet(int *)),
          a, SLOT(createGraphicSheet(int *)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestCreateAxisWindow(int, int *)),
          a, SLOT(createAxisWindow(int, int *)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestAddCurves(int, const CurveData *)),
          a, SLOT(addCurves(int, const CurveData *)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestPropertyValue(int, int, QVariant *)),
          a, SLOT(propertyValue(int, int, QVariant *)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestSetPropertyValue(int, int, PyObject *, bool *)),
          a, SLOT(setPropertyValue(int, int, PyObject *, bool *)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestMethod(int, int, PyObject *, MethodArgument **)),
          a, SLOT(method(int, int, PyObject *, MethodArgument **)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestSetVerbosity(int)), a, SLOT(setVerbosity(int)), Qt::QueuedConnection);
  connect(this, SIGNAL(requestQuit()), a, SLOT(quit()), Qt::QueuedConnection);
  a->initAcknowledge(&_acknowledge);
}

void ActionRequest::waitAcknowledge()
{
  _acknowledgeMutex.lock();
  _acknowledge.wait(&_acknowledgeMutex);
  _acknowledgeMutex.unlock();
}

int ActionRequest::createGraphicSheet()
{
  int objectId;
  emit requestCreateGraphicSheet(&objectId);
  waitAcknowledge();
  return objectId;
}

int ActionRequest::createAxisWindow(int parentId)
{
  int objectId;
  emit requestCreateAxisWindow(parentId, &objectId);
  waitAcknowledge();
  return objectId;
}

void ActionRequest::addCurves(int parentId, const CurveData * d)
{
  emit requestAddCurves(parentId, d);
  waitAcknowledge();
}

QVariant ActionRequest::propertyValue(int objectId, int propertyId)
{
  QVariant val;
  emit requestPropertyValue(objectId, propertyId, &val);
  waitAcknowledge();
  return val;
}

bool ActionRequest::setPropertyValue(int objectId, int propertyId, PyObject * args)
{
  bool ok;
  emit requestSetPropertyValue(objectId, propertyId, args, &ok);
  waitAcknowledge();
  return ok;
}

MethodArgument * ActionRequest::method(int objectId, int methodId, PyObject * args)
{
  MethodArgument * value=nullptr;
  emit requestMethod(objectId, methodId, args, &value);
  waitAcknowledge();
  return value;
}

void ActionRequest::setVerbosity(int level)
{
  emit requestSetVerbosity(level);
  waitAcknowledge();
}

void ActionRequest::quit()
{
  emit requestQuit();
}

#endif // HAS_PYTHON
